#  
#  SHA-512 hash in x86 assembly
#  
#  Copyright (c) 2014 Project Nayuki
#  http://www.nayuki.io/page/fast-sha2-hashes-in-x86-assembly
#  
#  (MIT License)
#  Permission is hereby granted, free of charge, to any person obtaining a copy of
#  this software and associated documentation files (the "Software"), to deal in
#  the Software without restriction, including without limitation the rights to
#  use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
#  the Software, and to permit persons to whom the Software is furnished to do so,
#  subject to the following conditions:
#  - The above copyright notice and this permission notice shall be included in
#    all copies or substantial portions of the Software.
#  - The Software is provided "as is", without warranty of any kind, express or
#    implied, including but not limited to the warranties of merchantability,
#    fitness for a particular purpose and noninfringement. In no event shall the
#    authors or copyright holders be liable for any claim, damages or other
#    liability, whether in an action of contract, tort or otherwise, arising from,
#    out of or in connection with the Software or the use or other dealings in the
#    Software.
# 

# Modified by kerukuro for use in cppcrypto.

 .ifdef MS_STDCALL
 .globl _sha512_compress_nayuki@8
 _sha512_compress_nayuki@8:
 .else
 .globl _sha512_compress_nayuki
 .globl sha512_compress_nayuki
 _sha512_compress_nayuki:
 sha512_compress_nayuki:
 .endif

 movl %esp, %ecx
 subl $192, %esp
 andl $~0xF, %esp


 movl 4(%ecx), %eax
 movdqu 0(%eax), %xmm0; movdqu %xmm0, 0(%esp)
 movdqu 16(%eax), %xmm1; movdqu %xmm1, 16(%esp)
 movdqu 32(%eax), %xmm2; movdqu %xmm2, 32(%esp)
 movdqu 48(%eax), %xmm3; movdqu %xmm3, 48(%esp)


 movl 8(%ecx), %eax
 movq .bswap64, %mm7
 movq (0*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((0)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+0*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (1*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((1)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+1*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (2*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((2)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+2*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (3*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((3)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+3*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (4*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((4)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+4*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (5*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((5)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+5*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (6*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((6)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+6*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (7*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((7)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+7*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (8*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((8)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+8*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (9*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((9)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+9*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (10*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((10)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+10*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (11*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((11)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+11*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (12*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((12)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+12*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (13*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((13)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+13*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (14*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((14)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+14*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (15*8)(%eax), %mm0; pshufb %mm7, %mm0; movq %mm0, (((15)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+15*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((16 -16)&0xF)*8+64)(%esp), %mm0; paddq (((16 - 7)&0xF)*8+64)(%esp), %mm0; movq (((16 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((16 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((16)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+16*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((17 -16)&0xF)*8+64)(%esp), %mm0; paddq (((17 - 7)&0xF)*8+64)(%esp), %mm0; movq (((17 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((17 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((17)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+17*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((18 -16)&0xF)*8+64)(%esp), %mm0; paddq (((18 - 7)&0xF)*8+64)(%esp), %mm0; movq (((18 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((18 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((18)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+18*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((19 -16)&0xF)*8+64)(%esp), %mm0; paddq (((19 - 7)&0xF)*8+64)(%esp), %mm0; movq (((19 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((19 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((19)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+19*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((20 -16)&0xF)*8+64)(%esp), %mm0; paddq (((20 - 7)&0xF)*8+64)(%esp), %mm0; movq (((20 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((20 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((20)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+20*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((21 -16)&0xF)*8+64)(%esp), %mm0; paddq (((21 - 7)&0xF)*8+64)(%esp), %mm0; movq (((21 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((21 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((21)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+21*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((22 -16)&0xF)*8+64)(%esp), %mm0; paddq (((22 - 7)&0xF)*8+64)(%esp), %mm0; movq (((22 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((22 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((22)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+22*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((23 -16)&0xF)*8+64)(%esp), %mm0; paddq (((23 - 7)&0xF)*8+64)(%esp), %mm0; movq (((23 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((23 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((23)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+23*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((24 -16)&0xF)*8+64)(%esp), %mm0; paddq (((24 - 7)&0xF)*8+64)(%esp), %mm0; movq (((24 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((24 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((24)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+24*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((25 -16)&0xF)*8+64)(%esp), %mm0; paddq (((25 - 7)&0xF)*8+64)(%esp), %mm0; movq (((25 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((25 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((25)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+25*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((26 -16)&0xF)*8+64)(%esp), %mm0; paddq (((26 - 7)&0xF)*8+64)(%esp), %mm0; movq (((26 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((26 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((26)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+26*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((27 -16)&0xF)*8+64)(%esp), %mm0; paddq (((27 - 7)&0xF)*8+64)(%esp), %mm0; movq (((27 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((27 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((27)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+27*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((28 -16)&0xF)*8+64)(%esp), %mm0; paddq (((28 - 7)&0xF)*8+64)(%esp), %mm0; movq (((28 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((28 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((28)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+28*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((29 -16)&0xF)*8+64)(%esp), %mm0; paddq (((29 - 7)&0xF)*8+64)(%esp), %mm0; movq (((29 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((29 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((29)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+29*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((30 -16)&0xF)*8+64)(%esp), %mm0; paddq (((30 - 7)&0xF)*8+64)(%esp), %mm0; movq (((30 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((30 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((30)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+30*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((31 -16)&0xF)*8+64)(%esp), %mm0; paddq (((31 - 7)&0xF)*8+64)(%esp), %mm0; movq (((31 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((31 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((31)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+31*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((32 -16)&0xF)*8+64)(%esp), %mm0; paddq (((32 - 7)&0xF)*8+64)(%esp), %mm0; movq (((32 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((32 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((32)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+32*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((33 -16)&0xF)*8+64)(%esp), %mm0; paddq (((33 - 7)&0xF)*8+64)(%esp), %mm0; movq (((33 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((33 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((33)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+33*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((34 -16)&0xF)*8+64)(%esp), %mm0; paddq (((34 - 7)&0xF)*8+64)(%esp), %mm0; movq (((34 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((34 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((34)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+34*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((35 -16)&0xF)*8+64)(%esp), %mm0; paddq (((35 - 7)&0xF)*8+64)(%esp), %mm0; movq (((35 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((35 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((35)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+35*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((36 -16)&0xF)*8+64)(%esp), %mm0; paddq (((36 - 7)&0xF)*8+64)(%esp), %mm0; movq (((36 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((36 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((36)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+36*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((37 -16)&0xF)*8+64)(%esp), %mm0; paddq (((37 - 7)&0xF)*8+64)(%esp), %mm0; movq (((37 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((37 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((37)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+37*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((38 -16)&0xF)*8+64)(%esp), %mm0; paddq (((38 - 7)&0xF)*8+64)(%esp), %mm0; movq (((38 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((38 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((38)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+38*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((39 -16)&0xF)*8+64)(%esp), %mm0; paddq (((39 - 7)&0xF)*8+64)(%esp), %mm0; movq (((39 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((39 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((39)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+39*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((40 -16)&0xF)*8+64)(%esp), %mm0; paddq (((40 - 7)&0xF)*8+64)(%esp), %mm0; movq (((40 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((40 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((40)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+40*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((41 -16)&0xF)*8+64)(%esp), %mm0; paddq (((41 - 7)&0xF)*8+64)(%esp), %mm0; movq (((41 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((41 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((41)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+41*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((42 -16)&0xF)*8+64)(%esp), %mm0; paddq (((42 - 7)&0xF)*8+64)(%esp), %mm0; movq (((42 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((42 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((42)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+42*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((43 -16)&0xF)*8+64)(%esp), %mm0; paddq (((43 - 7)&0xF)*8+64)(%esp), %mm0; movq (((43 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((43 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((43)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+43*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((44 -16)&0xF)*8+64)(%esp), %mm0; paddq (((44 - 7)&0xF)*8+64)(%esp), %mm0; movq (((44 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((44 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((44)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+44*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((45 -16)&0xF)*8+64)(%esp), %mm0; paddq (((45 - 7)&0xF)*8+64)(%esp), %mm0; movq (((45 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((45 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((45)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+45*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((46 -16)&0xF)*8+64)(%esp), %mm0; paddq (((46 - 7)&0xF)*8+64)(%esp), %mm0; movq (((46 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((46 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((46)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+46*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((47 -16)&0xF)*8+64)(%esp), %mm0; paddq (((47 - 7)&0xF)*8+64)(%esp), %mm0; movq (((47 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((47 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((47)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+47*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((48 -16)&0xF)*8+64)(%esp), %mm0; paddq (((48 - 7)&0xF)*8+64)(%esp), %mm0; movq (((48 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((48 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((48)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+48*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((49 -16)&0xF)*8+64)(%esp), %mm0; paddq (((49 - 7)&0xF)*8+64)(%esp), %mm0; movq (((49 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((49 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((49)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+49*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((50 -16)&0xF)*8+64)(%esp), %mm0; paddq (((50 - 7)&0xF)*8+64)(%esp), %mm0; movq (((50 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((50 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((50)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+50*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((51 -16)&0xF)*8+64)(%esp), %mm0; paddq (((51 - 7)&0xF)*8+64)(%esp), %mm0; movq (((51 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((51 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((51)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+51*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((52 -16)&0xF)*8+64)(%esp), %mm0; paddq (((52 - 7)&0xF)*8+64)(%esp), %mm0; movq (((52 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((52 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((52)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+52*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((53 -16)&0xF)*8+64)(%esp), %mm0; paddq (((53 - 7)&0xF)*8+64)(%esp), %mm0; movq (((53 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((53 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((53)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+53*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((54 -16)&0xF)*8+64)(%esp), %mm0; paddq (((54 - 7)&0xF)*8+64)(%esp), %mm0; movq (((54 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((54 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((54)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+54*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((55 -16)&0xF)*8+64)(%esp), %mm0; paddq (((55 - 7)&0xF)*8+64)(%esp), %mm0; movq (((55 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((55 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((55)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+55*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((56 -16)&0xF)*8+64)(%esp), %mm0; paddq (((56 - 7)&0xF)*8+64)(%esp), %mm0; movq (((56 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((56 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((56)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+56*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((57 -16)&0xF)*8+64)(%esp), %mm0; paddq (((57 - 7)&0xF)*8+64)(%esp), %mm0; movq (((57 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((57 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((57)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+57*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((58 -16)&0xF)*8+64)(%esp), %mm0; paddq (((58 - 7)&0xF)*8+64)(%esp), %mm0; movq (((58 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((58 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((58)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+58*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((59 -16)&0xF)*8+64)(%esp), %mm0; paddq (((59 - 7)&0xF)*8+64)(%esp), %mm0; movq (((59 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((59 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((59)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+59*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((60 -16)&0xF)*8+64)(%esp), %mm0; paddq (((60 - 7)&0xF)*8+64)(%esp), %mm0; movq (((60 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((60 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((60)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+60*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((61 -16)&0xF)*8+64)(%esp), %mm0; paddq (((61 - 7)&0xF)*8+64)(%esp), %mm0; movq (((61 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((61 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((61)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+61*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((62 -16)&0xF)*8+64)(%esp), %mm0; paddq (((62 - 7)&0xF)*8+64)(%esp), %mm0; movq (((62 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((62 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((62)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+62*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((63 -16)&0xF)*8+64)(%esp), %mm0; paddq (((63 - 7)&0xF)*8+64)(%esp), %mm0; movq (((63 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((63 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((63)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+63*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((64 -16)&0xF)*8+64)(%esp), %mm0; paddq (((64 - 7)&0xF)*8+64)(%esp), %mm0; movq (((64 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((64 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((64)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+64*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((65 -16)&0xF)*8+64)(%esp), %mm0; paddq (((65 - 7)&0xF)*8+64)(%esp), %mm0; movq (((65 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((65 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((65)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+65*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((66 -16)&0xF)*8+64)(%esp), %mm0; paddq (((66 - 7)&0xF)*8+64)(%esp), %mm0; movq (((66 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((66 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((66)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+66*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((67 -16)&0xF)*8+64)(%esp), %mm0; paddq (((67 - 7)&0xF)*8+64)(%esp), %mm0; movq (((67 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((67 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((67)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+67*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((68 -16)&0xF)*8+64)(%esp), %mm0; paddq (((68 - 7)&0xF)*8+64)(%esp), %mm0; movq (((68 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((68 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((68)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+68*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((69 -16)&0xF)*8+64)(%esp), %mm0; paddq (((69 - 7)&0xF)*8+64)(%esp), %mm0; movq (((69 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((69 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((69)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+69*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((70 -16)&0xF)*8+64)(%esp), %mm0; paddq (((70 - 7)&0xF)*8+64)(%esp), %mm0; movq (((70 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((70 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((70)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+70*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((71 -16)&0xF)*8+64)(%esp), %mm0; paddq (((71 - 7)&0xF)*8+64)(%esp), %mm0; movq (((71 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((71 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((71)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+71*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);
 movq (((72 -16)&0xF)*8+64)(%esp), %mm0; paddq (((72 - 7)&0xF)*8+64)(%esp), %mm0; movq (((72 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((72 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((72)&0xF)*8+64)(%esp); paddq (7*8)(%esp), %mm0; movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+72*8, %mm0; movq (6*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (3*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (3*8)(%esp); movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (2*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (1*8)(%esp), %mm3; pand (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (7*8)(%esp);
 movq (((73 -16)&0xF)*8+64)(%esp), %mm0; paddq (((73 - 7)&0xF)*8+64)(%esp), %mm0; movq (((73 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((73 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((73)&0xF)*8+64)(%esp); paddq (6*8)(%esp), %mm0; movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+73*8, %mm0; movq (5*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm2; pxor (5*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (2*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (2*8)(%esp); movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (1*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (0*8)(%esp), %mm3; pand (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (6*8)(%esp);
 movq (((74 -16)&0xF)*8+64)(%esp), %mm0; paddq (((74 - 7)&0xF)*8+64)(%esp), %mm0; movq (((74 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((74 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((74)&0xF)*8+64)(%esp); paddq (5*8)(%esp), %mm0; movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+74*8, %mm0; movq (4*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm2; pxor (4*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (1*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (1*8)(%esp); movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (0*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (7*8)(%esp), %mm3; pand (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (5*8)(%esp);
 movq (((75 -16)&0xF)*8+64)(%esp), %mm0; paddq (((75 - 7)&0xF)*8+64)(%esp), %mm0; movq (((75 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((75 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((75)&0xF)*8+64)(%esp); paddq (4*8)(%esp), %mm0; movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+75*8, %mm0; movq (3*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm2; pxor (3*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (0*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (0*8)(%esp); movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (7*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (6*8)(%esp), %mm3; pand (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (4*8)(%esp);
 movq (((76 -16)&0xF)*8+64)(%esp), %mm0; paddq (((76 - 7)&0xF)*8+64)(%esp), %mm0; movq (((76 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((76 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((76)&0xF)*8+64)(%esp); paddq (3*8)(%esp), %mm0; movq (0*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+76*8, %mm0; movq (2*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; pand (0*8)(%esp), %mm2; pxor (2*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (7*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (7*8)(%esp); movq (4*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (6*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (5*8)(%esp), %mm3; pand (5*8)(%esp), %mm2; pand (4*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (3*8)(%esp);
 movq (((77 -16)&0xF)*8+64)(%esp), %mm0; paddq (((77 - 7)&0xF)*8+64)(%esp), %mm0; movq (((77 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((77 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((77)&0xF)*8+64)(%esp); paddq (2*8)(%esp), %mm0; movq (7*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+77*8, %mm0; movq (1*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; pand (7*8)(%esp), %mm2; pxor (1*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (6*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (6*8)(%esp); movq (3*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (5*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (4*8)(%esp), %mm3; pand (4*8)(%esp), %mm2; pand (3*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (2*8)(%esp);
 movq (((78 -16)&0xF)*8+64)(%esp), %mm0; paddq (((78 - 7)&0xF)*8+64)(%esp), %mm0; movq (((78 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((78 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((78)&0xF)*8+64)(%esp); paddq (1*8)(%esp), %mm0; movq (6*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+78*8, %mm0; movq (0*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; pand (6*8)(%esp), %mm2; pxor (0*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (5*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (5*8)(%esp); movq (2*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (4*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (3*8)(%esp), %mm3; pand (3*8)(%esp), %mm2; pand (2*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (1*8)(%esp);
 movq (((79 -16)&0xF)*8+64)(%esp), %mm0; paddq (((79 - 7)&0xF)*8+64)(%esp), %mm0; movq (((79 -15)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-1), %mm5; psrlq $1, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-8), %mm4; psrlq $8, %mm2; por %mm4, %mm2; psrlq $7, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq (((79 - 2)&0xF)*8+64)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm5; psllq $(64-19), %mm5; psrlq $19, %mm1; por %mm5, %mm1; movq %mm2, %mm4; psllq $(64-61), %mm4; psrlq $61, %mm2; por %mm4, %mm2; psrlq $6, %mm3; pxor %mm3, %mm2; pxor %mm2, %mm1; paddq %mm1, %mm0; movq %mm0, (((79)&0xF)*8+64)(%esp); paddq (0*8)(%esp), %mm0; movq (5*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-18), %mm4; psrlq $18, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-41), %mm5; psrlq $41, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-14), %mm6; psrlq $14, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; paddq .roundconstants+79*8, %mm0; movq (7*8)(%esp), %mm2; pxor (6*8)(%esp), %mm2; pand (5*8)(%esp), %mm2; pxor (7*8)(%esp), %mm2; paddq %mm1, %mm0; paddq %mm2, %mm0; movq (4*8)(%esp), %mm1; paddq %mm0, %mm1; movq %mm1, (4*8)(%esp); movq (1*8)(%esp), %mm1; movq %mm1, %mm2; movq %mm1, %mm3; movq %mm1, %mm4; psllq $(64-39), %mm4; psrlq $39, %mm1; por %mm4, %mm1; movq %mm2, %mm5; psllq $(64-34), %mm5; psrlq $34, %mm2; por %mm5, %mm2; movq %mm3, %mm6; psllq $(64-28), %mm6; psrlq $28, %mm3; por %mm6, %mm3; pxor %mm2, %mm1; pxor %mm3, %mm1; movq (3*8)(%esp), %mm2; paddq %mm1, %mm0; movq %mm2, %mm3; por (2*8)(%esp), %mm3; pand (2*8)(%esp), %mm2; pand (1*8)(%esp), %mm3; por %mm2, %mm3; paddq %mm3, %mm0; movq %mm0, (0*8)(%esp);


 movl 4(%ecx), %eax
 movdqu 0(%eax), %xmm0; paddq 0(%esp), %xmm0; movdqu %xmm0, 0(%eax)
 movdqu 16(%eax), %xmm1; paddq 16(%esp), %xmm1; movdqu %xmm1, 16(%eax)
 movdqu 32(%eax), %xmm2; paddq 32(%esp), %xmm2; movdqu %xmm2, 32(%eax)
 movdqu 48(%eax), %xmm3; paddq 48(%esp), %xmm3; movdqu %xmm3, 48(%eax)


 emms
 movl %ecx, %esp

 .ifdef MS_STDCALL
	ret $8
 .else
	retl
 .endif


.balign 8
.bswap64:
 .quad 0x0001020304050607

.roundconstants:
 .quad 0x428A2F98D728AE22, 0x7137449123EF65CD, 0xB5C0FBCFEC4D3B2F, 0xE9B5DBA58189DBBC
 .quad 0x3956C25BF348B538, 0x59F111F1B605D019, 0x923F82A4AF194F9B, 0xAB1C5ED5DA6D8118
 .quad 0xD807AA98A3030242, 0x12835B0145706FBE, 0x243185BE4EE4B28C, 0x550C7DC3D5FFB4E2
 .quad 0x72BE5D74F27B896F, 0x80DEB1FE3B1696B1, 0x9BDC06A725C71235, 0xC19BF174CF692694
 .quad 0xE49B69C19EF14AD2, 0xEFBE4786384F25E3, 0x0FC19DC68B8CD5B5, 0x240CA1CC77AC9C65
 .quad 0x2DE92C6F592B0275, 0x4A7484AA6EA6E483, 0x5CB0A9DCBD41FBD4, 0x76F988DA831153B5
 .quad 0x983E5152EE66DFAB, 0xA831C66D2DB43210, 0xB00327C898FB213F, 0xBF597FC7BEEF0EE4
 .quad 0xC6E00BF33DA88FC2, 0xD5A79147930AA725, 0x06CA6351E003826F, 0x142929670A0E6E70
 .quad 0x27B70A8546D22FFC, 0x2E1B21385C26C926, 0x4D2C6DFC5AC42AED, 0x53380D139D95B3DF
 .quad 0x650A73548BAF63DE, 0x766A0ABB3C77B2A8, 0x81C2C92E47EDAEE6, 0x92722C851482353B
 .quad 0xA2BFE8A14CF10364, 0xA81A664BBC423001, 0xC24B8B70D0F89791, 0xC76C51A30654BE30
 .quad 0xD192E819D6EF5218, 0xD69906245565A910, 0xF40E35855771202A, 0x106AA07032BBD1B8
 .quad 0x19A4C116B8D2D0C8, 0x1E376C085141AB53, 0x2748774CDF8EEB99, 0x34B0BCB5E19B48A8
 .quad 0x391C0CB3C5C95A63, 0x4ED8AA4AE3418ACB, 0x5B9CCA4F7763E373, 0x682E6FF3D6B2B8A3
 .quad 0x748F82EE5DEFB2FC, 0x78A5636F43172F60, 0x84C87814A1F0AB72, 0x8CC702081A6439EC
 .quad 0x90BEFFFA23631E28, 0xA4506CEBDE82BDE9, 0xBEF9A3F7B2C67915, 0xC67178F2E372532B
 .quad 0xCA273ECEEA26619C, 0xD186B8C721C0C207, 0xEADA7DD6CDE0EB1E, 0xF57D4F7FEE6ED178
 .quad 0x06F067AA72176FBA, 0x0A637DC5A2C898A6, 0x113F9804BEF90DAE, 0x1B710B35131C471B
 .quad 0x28DB77F523047D84, 0x32CAAB7B40C72493, 0x3C9EBE0A15C9BEBC, 0x431D67C49C100D4C
 .quad 0x4CC5D4BECB3E42B6, 0x597F299CFC657E2A, 0x5FCB6FAB3AD6FAEC, 0x6C44198C4A475817

 .ifndef __YASM__
#if defined(__linux__) && defined(__ELF__)
 .section .note.GNU-stack,"",%progbits
#endif
 .endif